<?php
/*
* ARTURO: PAYPAL RECEIVER
* V. 3.0 
* Se activa paypal receiver para payment plugins for paypal.
* Se eliminan otras formas de pago paypal.
* Añadimos el modulo de paypal receiver. woocommerce_before_order_notes - woocommerce_review_order_before_payment -woocommerce_review_order_before_submit
* Al momento de hacer el update capturamos el dato que corresponda y lo grabamos en post_meta
* Aniadida la funcion get_paypal_payment_method (que antes se encontraba en wao-paypal-new.php)
*/
defined( 'ABSPATH' ) || exit;

// Asegúrate de incluir este archivo si aún no lo has hecho
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

// Verificar si el plugin Payment Plugins for PayPal está activo
if ( !is_plugin_active( 'pymntpl-paypal-woocommerce/pymntpl-paypal-woocommerce.php' ) ) {
    return; // Detiene la ejecución si el plugin no está activo
}

// Cuando hay compra pagada por paypal, insertar metadato _paypal_receiver
add_action('woocommerce_checkout_update_order_meta', 'my_custom_checkout_field_update_order_meta',10,2);
// Para insertar en los email de notificación de Pedido el campo personalizado. 
add_filter('woocommerce_email_order_meta_keys', 'my_custom_checkout_field_order_meta_keys');
// En configuracion de payment plugins for paypal, aumentar un campo de configuración pp_paypal_receiver
add_action('admin_footer', 'agregar_contenido_personalizado_gateway');///EL ULTIMO GRITO

function my_custom_checkout_field_update_order_meta( $order_id,$data ) {
	$order = wc_get_order( $order_id );	
	$metodo=$order->get_payment_method_title();
	//if(strpos($metodo,"paypal")!==FALSE){
	if(stristr($metodo, "paypal")){
		$ppm = get_paypal_payment_method();
		switch ($ppm){
			case "checkout":
				$options = get_option( 'woocommerce_ppec_paypal_settings' );//CHECKOUT
				$def=str_replace("_api1.","@",$options['api_username']);
				break;
			case "payments":
				$options = get_option( 'woocommerce-ppcp-settings' );//PAYMENTS
				$def=$options['merchant_email'];
				break;
			case "standard":
				$options = get_option( 'woocommerce_paypal_settings' );
				$def=$options['receiver_email'];
				break;
			case "gateway":
				$def = get_option( 'pp_current_user','Configure!');
				break;
			default:
				$def="Paypal receiver was not detected.(".$metodo.")"; // El receptor de paypal no fue detectado. Comunique al Departamento de Desarrollo.
				$depu['metodo']=$metodo; 
				$depu['ppm']=$ppm;
				update_post_meta($order_id,'depu',$depu);
		}
	    //update_post_meta( $order_id, 'depu1', $metodo);
	    update_post_meta( $order_id, 'paypal_receiver', $def);
	}
}// fin de function
function my_custom_checkout_field_order_meta_keys( $keys ) {
	$keys[] = 'paypal_receiver';
    return $keys;
}
function get_paypal_payment_method(){
	return "gateway"; //(esto en realidad es payment plugins for paypal)
}// function get_paypal_payment_method() end
function agregar_contenido_personalizado_gateway() {
    // Verificar si estamos en la página de configuración de PayPal en WooCommerce
    if (isset($_GET['page']) && $_GET['page'] === 'wc-settings' && isset($_GET['tab']) && $_GET['tab'] === 'checkout' && 
		isset($_GET['section']) && $_GET['section'] === 'ppcp_api') {
		if(isset($_POST['pp_paypal_receiver'])){
			//update_option("pp_current_user",$newuser);
			cuando_cambia_paypal_user($_POST['pp_paypal_receiver']);
		}
		$selyellow="";
		$selgreen="";
		$color=get_option('pp_color');
		$pp_paypal_receiver=get_option('pp_current_user');
		switch($color){case 'yellow':$selyellow='selected';break;case 'green':$selgreen='selected';break;}
		$html='<table class="form-table"><tr valign="top"><th scope="row" class="titledesc"><label for="pp_paypal_receiver">Email<span class="woocommerce-help-tip" tabindex="0" aria-label="Importante! Este dato se mostrar&aacute; en el widget."></span></label></th><td class="forminp"><input class="input-text regular-input" type="text" name="pp_paypal_receiver" id="pp_paypal_receiver" style="" value="'.$pp_paypal_receiver.'" placeholder=""><span style="margin-left:5px;font-size:12px;color:gray;">Importante colocar este dato!</span></td></tr></table>';
        ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // Obtener el elemento tr por su id
                var h3Element = document.getElementById('woocommerce_ppcp_api_title');
                // Verificar si el elemento tr existe antes de agregar el div
                if (h3Element) {
                    // Crear un nuevo div
                    nuevoDiv = '<?php echo $html; ?>';
                    // Insertar el nuevo div antes del elemento tr
                    //h3Element.parentNode.insertBefore(nuevoDiv, h3Element);
					h3Element.insertAdjacentHTML('afterend', nuevoDiv);
                }
            });
        </script>
        <?php
    }
}
function cuando_cambia_paypal_user($newuser){
	$olduser=get_option('pp_current_user','*');
	if($newuser<>$olduser){
		$history = get_option("pp_history",array());
		$today = date('Y-m-d H:i:s');
		$history[]=array('user'=>$olduser,'date'=>$today,'allsales'=>get_option('pp_allsales'),'credentials'=>credentials());
		update_option("pp_history",$history);
		update_option("pp_allsales",0);
		update_option("pp_todaysales",0);
		update_option("pp_monthsales",0);
		update_option("pp_current_user",$newuser);
	}
}
function credentials(){
	switch(get_paypal_payment_method()){
		case "payments":
			$info=get_option('woocommerce-ppcp-settings',array('merchant_email'=>'new','client_secret'=>'new','client_id'=>'new','merchant_id'=>'new',));
			$retorno['merchant_email']=$info['merchant_email'];
			$retorno['client_secret']=$info['client_secret'];
			$retorno['client_id']=$info['client_id'];
			$retorno['merchant_id']=$info['merchant_id'];
			break;
		case "checkout":
			$info=get_option('woocommerce_ppec_paypal_settings',array('api_username'=>'new','api_signature'=>'new','api_password'=>'new'));
			$retorno['api_username']=$info['api_username'];
			$retorno['api_signature']=$info['api_signature'];
			$retorno['api_password']=$info['api_password'];
			break;
		case "gateway":
			$info=get_option('woocommerce_ppcp_api_settings',array('client_id_production'=>'new','secret_key_production'=>'new','merchant_id_production'=>'new'));
			$retorno['email']=get_option('pp_current_user');
			$retorno['client_id_production']=$info['client_id_production'];
			$retorno['secret_key_production']=$info['secret_key_production'];
			$retorno['merchant_id_production']=$info['merchant_id_production'];
			break;
	}
	return $retorno;
}
