<?php

namespace PaymentPlugins\WooCommerce\PPCP\Utilities;

class LocaleUtil {

	public static function get_site_locale( $bpc47 = false ) {
		$locale = get_locale();
		if ( strlen( $locale ) === 2 ) {
			if ( $locale === 'en' ) {
				$locale = 'en_US';
			} elseif ( $locale === 'fr' ) {
				$locale = 'fr_XC';
			} elseif ( $locale === 'es' ) {
				$locale = 'es_XC';
			} elseif ( $locale === 'zh' ) {
				$locale = 'zh_XC';
			} else {
				// en = en_EN
				$locale = "{$locale}_" . strtoupper( $locale );
			}
		} elseif ( strlen( $locale ) > 5 ) {
			$locale = substr( $locale, 0, 5 );
		}

		if ( $bpc47 ) {
			$locale = str_replace( '_', '-', $locale );
		}

		return apply_filters( 'wc_ppcp_get_site_locale', $locale, $bpc47 );
	}

	public static function is_locale_supported( $locale, $bpc47 = false ) {
		if ( $bpc47 ) {
			return \in_array( $locale, self::get_bcp47_locales(), true );
		}

		return apply_filters( 'wc_ppcp_is_locale_supported', \in_array( $locale, self::get_frontend_locales(), true ), $locale, $bpc47 );
	}

	private static function get_frontend_locales() {
		return [
			'en_AL',
			'ar_DZ',
			'en_DZ',
			'fr_DZ',
			'es_DZ',
			'zh_DZ',
			'en_AD',
			'fr_AD',
			'es_AD',
			'zh_AD',
			'en_AO',
			'fr_AO',
			'es_AO',
			'zh_AO',
			'en_AI',
			'fr_AI',
			'es_AI',
			'zh_AI',
			'en_AG',
			'fr_AG',
			'es_AG',
			'zh_AG',
			'es_AR',
			'en_AR',
			'en_AM',
			'fr_AM',
			'es_AM',
			'zh_AM',
			'en_AW',
			'fr_AW',
			'es_AW',
			'zh_AW',
			'en_AU',
			'de_AT',
			'en_AT',
			'en_AZ',
			'fr_AZ',
			'es_AZ',
			'zh_AZ',
			'en_BS',
			'fr_BS',
			'es_BS',
			'zh_BS',
			'ar_BH',
			'en_BH',
			'fr_BH',
			'es_BH',
			'zh_BH',
			'en_BB',
			'fr_BB',
			'es_BB',
			'zh_BB',
			'en_BY',
			'en_BE',
			'nl_BE',
			'fr_BE',
			'en_BZ',
			'es_BZ',
			'fr_BZ',
			'zh_BZ',
			'fr_BJ',
			'en_BJ',
			'es_BJ',
			'zh_BJ',
			'en_BM',
			'fr_BM',
			'es_BM',
			'zh_BM',
			'en_BT',
			'es_BO',
			'en_BO',
			'fr_BO',
			'zh_BO',
			'en_BA',
			'en_BW',
			'fr_BW',
			'es_BW',
			'zh_BW',
			'pt_BR',
			'en_BR',
			'en_VG',
			'fr_VG',
			'es_VG',
			'zh_VG',
			'en_BN',
			'en_BG',
			'fr_BF',
			'en_BF',
			'es_BF',
			'zh_BF',
			'fr_BI',
			'en_BI',
			'es_BI',
			'zh_BI',
			'en_KH',
			'fr_CM',
			'en_CM',
			'en_CA',
			'fr_CA',
			'en_CV',
			'fr_CV',
			'es_CV',
			'zh_CV',
			'en_KY',
			'fr_KY',
			'es_KY',
			'zh_KY',
			'fr_TD',
			'en_TD',
			'es_TD',
			'zh_TD',
			'es_CL',
			'en_CL',
			'fr_CL',
			'zh_CL',
			'zh_CN',
			'es_CO',
			'en_CO',
			'fr_CO',
			'zh_CO',
			'fr_KM',
			'en_KM',
			'es_KM',
			'zh_KM',
			'en_CG',
			'fr_CG',
			'es_CG',
			'zh_CG',
			'fr_CD',
			'en_CD',
			'es_CD',
			'zh_CD',
			'en_CK',
			'fr_CK',
			'es_CK',
			'zh_CK',
			'es_CR',
			'en_CR',
			'fr_CR',
			'zh_CR',
			'fr_CI',
			'en_CI',
			'en_HR',
			'en_CY',
			'cs_CZ',
			'en_CZ',
			'fr_CZ',
			'es_CZ',
			'zh_CZ',
			'da_DK',
			'en_DK',
			'fr_DJ',
			'en_DJ',
			'es_DJ',
			'zh_DJ',
			'en_DM',
			'fr_DM',
			'es_DM',
			'zh_DM',
			'es_DO',
			'en_DO',
			'fr_DO',
			'zh_DO',
			'es_EC',
			'en_EC',
			'fr_EC',
			'zh_EC',
			'ar_EG',
			'en_EG',
			'fr_EG',
			'es_EG',
			'zh_EG',
			'es_SV',
			'en_SV',
			'fr_SV',
			'zh_SV',
			'en_ER',
			'fr_ER',
			'es_ER',
			'zh_ER',
			'en_EE',
			'ru_EE',
			'fr_EE',
			'es_EE',
			'zh_EE',
			'en_ET',
			'fr_ET',
			'es_ET',
			'zh_ET',
			'en_FK',
			'fr_FK',
			'es_FK',
			'zh_FK',
			'da_FO',
			'en_FO',
			'fr_FO',
			'es_FO',
			'zh_FO',
			'en_FJ',
			'fr_FJ',
			'es_FJ',
			'zh_FJ',
			'fi_FI',
			'en_FI',
			'fr_FI',
			'es_FI',
			'zh_FI',
			'fr_FR',
			'en_FR',
			'en_GF',
			'fr_GF',
			'es_GF',
			'zh_GF',
			'en_PF',
			'fr_PF',
			'es_PF',
			'zh_PF',
			'fr_GA',
			'en_GA',
			'es_GA',
			'zh_GA',
			'en_GM',
			'fr_GM',
			'es_GM',
			'zh_GM',
			'en_GE',
			'fr_GE',
			'es_GE',
			'zh_GE',
			'de_DE',
			'en_DE',
			'en_GI',
			'fr_GI',
			'es_GI',
			'zh_GI',
			'el_GR',
			'en_GR',
			'fr_GR',
			'es_GR',
			'zh_GR',
			'da_GL',
			'en_GL',
			'fr_GL',
			'es_GL',
			'zh_GL',
			'en_GD',
			'fr_GD',
			'es_GD',
			'zh_GD',
			'en_GP',
			'fr_GP',
			'es_GP',
			'zh_GP',
			'es_GT',
			'en_GT',
			'fr_GT',
			'zh_GT',
			'fr_GN',
			'en_GN',
			'es_GN',
			'zh_GN',
			'en_GW',
			'fr_GW',
			'es_GW',
			'zh_GW',
			'en_GY',
			'fr_GY',
			'es_GY',
			'zh_GY',
			'es_HN',
			'en_HN',
			'fr_HN',
			'zh_HN',
			'en_HK',
			'zh_HK',
			'hu_HU',
			'en_HU',
			'fr_HU',
			'es_HU',
			'zh_HU',
			'en_IS',
			'en_IN',
			'id_ID',
			'en_ID',
			'en_IE',
			'fr_IE',
			'es_IE',
			'zh_IE',
			'he_IL',
			'en_IL',
			'it_IT',
			'en_IT',
			'en_JM',
			'es_JM',
			'fr_JM',
			'zh_JM',
			'ja_JP',
			'en_JP',
			'ar_JO',
			'en_JO',
			'fr_JO',
			'es_JO',
			'zh_JO',
			'en_KZ',
			'fr_KZ',
			'es_KZ',
			'zh_KZ',
			'en_KE',
			'fr_KE',
			'es_KE',
			'zh_KE',
			'en_KI',
			'fr_KI',
			'es_KI',
			'zh_KI',
			'ar_KW',
			'en_KW',
			'fr_KW',
			'es_KW',
			'zh_KW',
			'en_KG',
			'fr_KG',
			'es_KG',
			'zh_KG',
			'en_LA',
			'en_LV',
			'ru_LV',
			'fr_LV',
			'es_LV',
			'zh_LV',
			'en_LS',
			'fr_LS',
			'es_LS',
			'zh_LS',
			'en_LI',
			'fr_LI',
			'es_LI',
			'zh_LI',
			'en_LT',
			'ru_LT',
			'fr_LT',
			'es_LT',
			'zh_LT',
			'en_LU',
			'de_LU',
			'fr_LU',
			'es_LU',
			'zh_LU',
			'en_MK',
			'en_MG',
			'fr_MG',
			'es_MG',
			'zh_MG',
			'en_MW',
			'fr_MW',
			'es_MW',
			'zh_MW',
			'en_MY',
			'en_MV',
			'fr_ML',
			'en_ML',
			'es_ML',
			'zh_ML',
			'en_MT',
			'en_MH',
			'fr_MH',
			'es_MH',
			'zh_MH',
			'en_MQ',
			'fr_MQ',
			'es_MQ',
			'zh_MQ',
			'en_MR',
			'fr_MR',
			'es_MR',
			'zh_MR',
			'en_MU',
			'fr_MU',
			'es_MU',
			'zh_MU',
			'en_YT',
			'fr_YT',
			'es_YT',
			'zh_YT',
			'es_MX',
			'en_MX',
			'en_FM',
			'en_MD',
			'fr_MC',
			'en_MC',
			'en_MN',
			'en_ME',
			'en_MS',
			'fr_MS',
			'es_MS',
			'zh_MS',
			'ar_MA',
			'en_MA',
			'fr_MA',
			'es_MA',
			'zh_MA',
			'en_MZ',
			'fr_MZ',
			'es_MZ',
			'zh_MZ',
			'en_NA',
			'fr_NA',
			'es_NA',
			'zh_NA',
			'en_NR',
			'fr_NR',
			'es_NR',
			'zh_NR',
			'en_NP',
			'nl_NL',
			'en_NL',
			'en_AN',
			'fr_AN',
			'es_AN',
			'zh_AN',
			'en_NC',
			'fr_NC',
			'es_NC',
			'zh_NC',
			'en_NZ',
			'fr_NZ',
			'es_NZ',
			'zh_NZ',
			'es_NI',
			'en_NI',
			'fr_NI',
			'zh_NI',
			'fr_NE',
			'en_NE',
			'es_NE',
			'zh_NE',
			'en_NG',
			'en_NU',
			'fr_NU',
			'es_NU',
			'zh_NU',
			'en_NF',
			'fr_NF',
			'es_NF',
			'zh_NF',
			'no_NO',
			'en_NO',
			'ar_OM',
			'en_OM',
			'fr_OM',
			'es_OM',
			'zh_OM',
			'en_PW',
			'fr_PW',
			'es_PW',
			'zh_PW',
			'es_PA',
			'en_PA',
			'fr_PA',
			'zh_PA',
			'en_PG',
			'fr_PG',
			'es_PG',
			'zh_PG',
			'es_PY',
			'en_PY',
			'es_PE',
			'en_PE',
			'fr_PE',
			'zh_PE',
			'en_PH',
			'en_PN',
			'fr_PN',
			'es_PN',
			'zh_PN',
			'pl_PL',
			'en_PL',
			'pt_PT',
			'en_PT',
			'en_QA',
			'fr_QA',
			'es_QA',
			'zh_QA',
			'ar_QA',
			'en_RE',
			'fr_RE',
			'es_RE',
			'zh_RE',
			'en_RO',
			'fr_RO',
			'es_RO',
			'zh_RO',
			'ru_RU',
			'en_RU',
			'fr_RW',
			'en_RW',
			'es_RW',
			'zh_RW',
			'en_WS',
			'en_SM',
			'fr_SM',
			'es_SM',
			'zh_SM',
			'en_ST',
			'fr_ST',
			'es_ST',
			'zh_ST',
			'ar_SA',
			'en_SA',
			'fr_SA',
			'es_SA',
			'zh_SA',
			'fr_SN',
			'en_SN',
			'es_SN',
			'zh_SN',
			'en_RS',
			'fr_RS',
			'es_RS',
			'zh_RS',
			'fr_SC',
			'en_SC',
			'es_SC',
			'zh_SC',
			'en_SL',
			'fr_SL',
			'es_SL',
			'zh_SL',
			'en_SG',
			'sk_SK',
			'en_SK',
			'fr_SK',
			'es_SK',
			'zh_SK',
			'en_SI',
			'fr_SI',
			'es_SI',
			'zh_SI',
			'en_SB',
			'fr_SB',
			'es_SB',
			'zh_SB',
			'en_SO',
			'fr_SO',
			'es_SO',
			'zh_SO',
			'en_ZA',
			'fr_ZA',
			'es_ZA',
			'zh_ZA',
			'ko_KR',
			'en_KR',
			'es_ES',
			'en_ES',
			'en_LK',
			'en_SH',
			'fr_SH',
			'es_SH',
			'zh_SH',
			'en_KN',
			'fr_KN',
			'es_KN',
			'zh_KN',
			'en_LC',
			'fr_LC',
			'es_LC',
			'zh_LC',
			'en_PM',
			'fr_PM',
			'es_PM',
			'zh_PM',
			'en_VC',
			'fr_VC',
			'es_VC',
			'zh_VC',
			'en_SR',
			'fr_SR',
			'es_SR',
			'zh_SR',
			'en_SJ',
			'fr_SJ',
			'es_SJ',
			'zh_SJ',
			'en_SZ',
			'fr_SZ',
			'es_SZ',
			'zh_SZ',
			'sv_SE',
			'en_SE',
			'de_CH',
			'fr_CH',
			'en_CH',
			'zh_TW',
			'en_TW',
			'en_TJ',
			'fr_TJ',
			'es_TJ',
			'zh_TJ',
			'en_TZ',
			'fr_TZ',
			'es_TZ',
			'zh_TZ',
			'th_TH',
			'en_TH',
			'fr_TG',
			'en_TG',
			'es_TG',
			'zh_TG',
			'en_TO',
			'en_TT',
			'fr_TT',
			'es_TT',
			'zh_TT',
			'ar_TN',
			'en_TN',
			'fr_TN',
			'es_TN',
			'zh_TN',
			'en_TM',
			'fr_TM',
			'es_TM',
			'zh_TM',
			'en_TC',
			'fr_TC',
			'es_TC',
			'zh_TC',
			'en_TV',
			'fr_TV',
			'es_TV',
			'zh_TV',
			'tr_TR',
			'en_TR',
			'en_UG',
			'fr_UG',
			'es_UG',
			'zh_UG',
			'en_UA',
			'ru_UA',
			'fr_UA',
			'es_UA',
			'zh_UA',
			'en_AE',
			'fr_AE',
			'es_AE',
			'zh_AE',
			'ar_AE',
			'en_GB',
			'en_US',
			'fr_US',
			'es_US',
			'zh_US',
			'es_UY',
			'en_UY',
			'fr_UY',
			'zh_UY',
			'en_VU',
			'fr_VU',
			'es_VU',
			'zh_VU',
			'en_VA',
			'fr_VA',
			'es_VA',
			'zh_VA',
			'es_VE',
			'en_VE',
			'fr_VE',
			'zh_VE',
			'en_VN',
			'en_WF',
			'fr_WF',
			'es_WF',
			'zh_WF',
			'ar_YE',
			'en_YE',
			'fr_YE',
			'es_YE',
			'zh_YE',
			'en_ZM',
			'fr_ZM',
			'es_ZM',
			'zh_ZM',
			'en_ZW'
		];
	}

	public static function get_bcp47_locales() {
		return [
			"en-AL",
			"ar-DZ",
			"en-DZ",
			"fr-DZ",
			"es-DZ",
			"zh-DZ",
			"en-AD",
			"fr-AD",
			"es-AD",
			"zh-AD",
			"en-AO",
			"fr-AO",
			"es-AO",
			"zh-AO",
			"en-AI",
			"fr-AI",
			"es-AI",
			"zh-AI",
			"en-AG",
			"fr-AG",
			"es-AG",
			"zh-AG",
			"es-AR",
			"en-AR",
			"en-AM",
			"fr-AM",
			"es-AM",
			"zh-AM",
			"en-AW",
			"fr-AW",
			"es-AW",
			"zh-AW",
			"en-AU",
			"de-AT",
			"en-AT",
			"en-AZ",
			"fr-AZ",
			"es-AZ",
			"zh-AZ",
			"en-BS",
			"fr-BS",
			"es-BS",
			"zh-BS",
			"ar-BH",
			"en-BH",
			"fr-BH",
			"es-BH",
			"zh-BH",
			"en-BB",
			"fr-BB",
			"es-BB",
			"zh-BB",
			"en-BY",
			"en-BE",
			"nl-BE",
			"fr-BE",
			"es-BZ",
			"en-BZ",
			"fr-BZ",
			"zh-BZ",
			"fr-BJ",
			"en-BJ",
			"es-BJ",
			"zh-BJ",
			"en-BM",
			"fr-BM",
			"es-BM",
			"zh-BM",
			"en-BT",
			"es-BO",
			"en-BO",
			"fr-BO",
			"zh-BO",
			"en-BA",
			"en-BW",
			"fr-BW",
			"es-BW",
			"zh-BW",
			"pt-BR",
			"en-BR",
			"en-VG",
			"fr-VG",
			"es-VG",
			"zh-VG",
			"en-BN",
			"en-BG",
			"fr-BF",
			"en-BF",
			"es-BF",
			"zh-BF",
			"fr-BI",
			"en-BI",
			"es-BI",
			"zh-BI",
			"en-KH",
			"fr-CM",
			"en-CM",
			"en-CA",
			"fr-CA",
			"en-CV",
			"fr-CV",
			"es-CV",
			"zh-CV",
			"en-KY",
			"fr-KY",
			"es-KY",
			"zh-KY",
			"fr-TD",
			"en-TD",
			"es-TD",
			"zh-TD",
			"es-CL",
			"en-CL",
			"fr-CL",
			"zh-CL",
			"zh-CN",
			"zh-CN",
			"en-CN",
			"es-CO",
			"en-CO",
			"fr-CO",
			"zh-CO",
			"fr-KM",
			"en-KM",
			"es-KM",
			"zh-KM",
			"en-CG",
			"fr-CG",
			"es-CG",
			"zh-CG",
			"fr-CD",
			"en-CD",
			"es-CD",
			"zh-CD",
			"en-CK",
			"fr-CK",
			"es-CK",
			"zh-CK",
			"es-CR",
			"en-CR",
			"fr-CR",
			"zh-CR",
			"fr-CI",
			"en-CI",
			"en-HR",
			"en-CY",
			"cs-CZ",
			"en-CZ",
			"fr-CZ",
			"es-CZ",
			"zh-CZ",
			"da-DK",
			"en-DK",
			"fr-DJ",
			"en-DJ",
			"es-DJ",
			"zh-DJ",
			"en-DM",
			"fr-DM",
			"es-DM",
			"zh-DM",
			"es-DO",
			"en-DO",
			"fr-DO",
			"zh-DO",
			"es-EC",
			"en-EC",
			"fr-EC",
			"zh-EC",
			"ar-EG",
			"en-EG",
			"fr-EG",
			"es-EG",
			"zh-EG",
			"es-SV",
			"en-SV",
			"fr-SV",
			"zh-SV",
			"en-ER",
			"fr-ER",
			"es-ER",
			"zh-ER",
			"en-EE",
			"ru-EE",
			"fr-EE",
			"es-EE",
			"zh-EE",
			"en-ET",
			"fr-ET",
			"es-ET",
			"zh-ET",
			"en-FK",
			"fr-FK",
			"es-FK",
			"zh-FK",
			"da-FO",
			"en-FO",
			"fr-FO",
			"es-FO",
			"zh-FO",
			"en-FJ",
			"fr-FJ",
			"es-FJ",
			"zh-FJ",
			"fi-FI",
			"en-FI",
			"fr-FI",
			"es-FI",
			"zh-FI",
			"fr-FR",
			"en-FR",
			"en-GF",
			"fr-GF",
			"es-GF",
			"zh-GF",
			"en-PF",
			"fr-PF",
			"es-PF",
			"zh-PF",
			"fr-GA",
			"en-GA",
			"es-GA",
			"zh-GA",
			"en-GM",
			"fr-GM",
			"es-GM",
			"zh-GM",
			"en-GE",
			"fr-GE",
			"es-GE",
			"zh-GE",
			"de-DE",
			"en-DE",
			"en-GI",
			"fr-GI",
			"es-GI",
			"zh-GI",
			"el-GR",
			"en-GR",
			"fr-GR",
			"es-GR",
			"zh-GR",
			"da-GL",
			"en-GL",
			"fr-GL",
			"es-GL",
			"zh-GL",
			"en-GD",
			"fr-GD",
			"es-GD",
			"zh-GD",
			"en-GP",
			"fr-GP",
			"es-GP",
			"zh-GP",
			"es-GT",
			"en-GT",
			"fr-GT",
			"zh-GT",
			"fr-GN",
			"en-GN",
			"es-GN",
			"zh-GN",
			"en-GW",
			"fr-GW",
			"es-GW",
			"zh-GW",
			"en-GY",
			"fr-GY",
			"es-GY",
			"zh-GY",
			"fr-HT",
			"en-HT",
			"es-HT",
			"zh-HT",
			"es-HN",
			"en-HN",
			"fr-HN",
			"zh-HN",
			"en-HK",
			"zh-HK",
			"hu-HU",
			"en-HU",
			"fr-HU",
			"es-HU",
			"zh-HU",
			"en-IS",
			"en-IN",
			"id-ID",
			"en-ID",
			"en-IE",
			"fr-IE",
			"es-IE",
			"zh-IE",
			"he-IL",
			"en-IL",
			"it-IT",
			"en-IT",
			"es-JM",
			"en-JM",
			"fr-JM",
			"zh-JM",
			"ja-JP",
			"en-JP",
			"ar-JO",
			"en-JO",
			"fr-JO",
			"es-JO",
			"zh-JO",
			"en-KZ",
			"fr-KZ",
			"es-KZ",
			"zh-KZ",
			"en-KE",
			"fr-KE",
			"es-KE",
			"zh-KE",
			"en-KI",
			"fr-KI",
			"es-KI",
			"zh-KI",
			"ko-KR",
			"en-KR",
			"ar-KW",
			"en-KW",
			"fr-KW",
			"es-KW",
			"zh-KW",
			"en-KG",
			"fr-KG",
			"es-KG",
			"zh-KG",
			"en-LA",
			"en-LV",
			"ru-LV",
			"fr-LV",
			"es-LV",
			"zh-LV",
			"en-LS",
			"fr-LS",
			"es-LS",
			"zh-LS",
			"en-LI",
			"fr-LI",
			"es-LI",
			"zh-LI",
			"en-LT",
			"ru-LT",
			"fr-LT",
			"es-LT",
			"zh-LT",
			"en-LU",
			"de-LU",
			"fr-LU",
			"es-LU",
			"zh-LU",
			"en-MK",
			"en-MG",
			"fr-MG",
			"es-MG",
			"zh-MG",
			"en-MW",
			"fr-MW",
			"es-MW",
			"zh-MW",
			"en-MY",
			"en-MV",
			"fr-ML",
			"en-ML",
			"es-ML",
			"zh-ML",
			"en-MT",
			"en-MH",
			"fr-MH",
			"es-MH",
			"zh-MH",
			"en-MQ",
			"fr-MQ",
			"es-MQ",
			"zh-MQ",
			"en-MR",
			"fr-MR",
			"es-MR",
			"zh-MR",
			"en-MU",
			"fr-MU",
			"es-MU",
			"zh-MU",
			"en-YT",
			"fr-YT",
			"es-YT",
			"zh-YT",
			"es-MX",
			"en-MX",
			"en-FM",
			"en-MD",
			"fr-MC",
			"en-MC",
			"en-MN",
			"en-ME",
			"en-MS",
			"fr-MS",
			"es-MS",
			"zh-MS",
			"ar-MA",
			"en-MA",
			"fr-MA",
			"es-MA",
			"zh-MA",
			"en-MZ",
			"fr-MZ",
			"es-MZ",
			"zh-MZ",
			"en-NA",
			"fr-NA",
			"es-NA",
			"zh-NA",
			"en-NR",
			"fr-NR",
			"es-NR",
			"zh-NR",
			"en-NP",
			"nl-NL",
			"en-NL",
			"en-NC",
			"fr-NC",
			"es-NC",
			"zh-NC",
			"en-NZ",
			"fr-NZ",
			"es-NZ",
			"zh-NZ",
			"es-NI",
			"en-NI",
			"fr-NI",
			"zh-NI",
			"fr-NE",
			"en-NE",
			"es-NE",
			"zh-NE",
			"en-NG",
			"en-NU",
			"fr-NU",
			"es-NU",
			"zh-NU",
			"en-NF",
			"fr-NF",
			"es-NF",
			"zh-NF",
			"no-NO",
			"en-NO",
			"ar-OM",
			"en-OM",
			"fr-OM",
			"es-OM",
			"zh-OM",
			"en-PW",
			"fr-PW",
			"es-PW",
			"zh-PW",
			"es-PA",
			"en-PA",
			"fr-PA",
			"zh-PA",
			"en-PG",
			"fr-PG",
			"es-PG",
			"zh-PG",
			"es-PY",
			"en-PY",
			"es-PE",
			"en-PE",
			"fr-PE",
			"zh-PE",
			"en-PH",
			"en-PN",
			"fr-PN",
			"es-PN",
			"zh-PN",
			"pl-PL",
			"en-PL",
			"pt-PT",
			"en-PT",
			"en-QA",
			"fr-QA",
			"es-QA",
			"zh-QA",
			"ar-QA",
			"en-RE",
			"fr-RE",
			"es-RE",
			"zh-RE",
			"en-RO",
			"fr-RO",
			"es-RO",
			"zh-RO",
			"ru-RU",
			"en-RU",
			"fr-RW",
			"en-RW",
			"es-RW",
			"zh-RW",
			"en-WS",
			"en-SM",
			"fr-SM",
			"es-SM",
			"zh-SM",
			"en-ST",
			"fr-ST",
			"es-ST",
			"zh-ST",
			"ar-SA",
			"en-SA",
			"fr-SA",
			"es-SA",
			"zh-SA",
			"fr-SN",
			"en-SN",
			"es-SN",
			"zh-SN",
			"en-RS",
			"fr-RS",
			"es-RS",
			"zh-RS",
			"fr-SC",
			"en-SC",
			"es-SC",
			"zh-SC",
			"en-SL",
			"fr-SL",
			"es-SL",
			"zh-SL",
			"en-SG",
			"sk-SK",
			"en-SK",
			"fr-SK",
			"es-SK",
			"zh-SK",
			"en-SI",
			"fr-SI",
			"es-SI",
			"zh-SI",
			"en-SB",
			"fr-SB",
			"es-SB",
			"zh-SB",
			"en-SO",
			"fr-SO",
			"es-SO",
			"zh-SO",
			"en-ZA",
			"fr-ZA",
			"es-ZA",
			"zh-ZA",
			"es-ES",
			"en-ES",
			"en-LK",
			"en-SH",
			"fr-SH",
			"es-SH",
			"zh-SH",
			"en-KN",
			"fr-KN",
			"es-KN",
			"zh-KN",
			"en-LC",
			"fr-LC",
			"es-LC",
			"zh-LC",
			"en-PM",
			"fr-PM",
			"es-PM",
			"zh-PM",
			"en-VC",
			"fr-VC",
			"es-VC",
			"zh-VC",
			"en-SR",
			"fr-SR",
			"es-SR",
			"zh-SR",
			"en-SJ",
			"fr-SJ",
			"es-SJ",
			"zh-SJ",
			"en-SZ",
			"fr-SZ",
			"es-SZ",
			"zh-SZ",
			"sv-SE",
			"en-SE",
			"de-CH",
			"fr-CH",
			"en-CH",
			"zh-TW",
			"en-TW",
			"en-TJ",
			"fr-TJ",
			"es-TJ",
			"zh-TJ",
			"en-TZ",
			"fr-TZ",
			"es-TZ",
			"zh-TZ",
			"th-TH",
			"en-TH",
			"fr-TG",
			"en-TG",
			"es-TG",
			"zh-TG",
			"en-TO",
			"en-TT",
			"fr-TT",
			"es-TT",
			"zh-TT",
			"ar-TN",
			"en-TN",
			"fr-TN",
			"es-TN",
			"zh-TN",
			"en-TM",
			"fr-TM",
			"es-TM",
			"zh-TM",
			"en-TC",
			"fr-TC",
			"es-TC",
			"zh-TC",
			"en-TV",
			"fr-TV",
			"es-TV",
			"zh-TV",
			"en-UG",
			"fr-UG",
			"es-UG",
			"zh-UG",
			"en-UA",
			"ru-UA",
			"fr-UA",
			"es-UA",
			"zh-UA",
			"en-AE",
			"fr-AE",
			"es-AE",
			"zh-AE",
			"ar-AE",
			"en-GB",
			"en-US",
			"fr-US",
			"es-US",
			"zh-US",
			"es-UY",
			"en-UY",
			"fr-UY",
			"zh-UY",
			"en-VU",
			"fr-VU",
			"es-VU",
			"zh-VU",
			"en-VA",
			"fr-VA",
			"es-VA",
			"zh-VA",
			"es-VE",
			"en-VE",
			"fr-VE",
			"zh-VE",
			"en-VN",
			"en-WF",
			"fr-WF",
			"es-WF",
			"zh-WF",
			"ar-YE",
			"en-YE",
			"fr-YE",
			"es-YE",
			"zh-YE",
			"en-ZM",
			"fr-ZM",
			"es-ZM",
			"zh-ZM",
			"en-ZW"
		];
	}

}